/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Log;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Parsers;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;

public class Image
extends Pane {
    public static final int MINECRAFT_DEFAULT_TEXTURE_IMAGE_SIZE = 256;
    protected ResourceLocation resourceLocation;
    protected int u = 0;
    protected int v = 0;
    protected int imageWidth = 0;
    protected int imageHeight = 0;
    protected int fileWidth = 256;
    protected int fileHeight = 256;
    protected boolean customSized = true;
    protected boolean autoscale = true;

    public Image() {
    }

    public Image(PaneParams params) {
        super(params);
        this.resourceLocation = params.getResource("source", this::loadMapDimensions);
        params.applyShorthand("imageoffset", Parsers.INT, 2, a -> {
            this.u = (Integer)a.get(0);
            this.v = (Integer)a.get(1);
        });
        params.applyShorthand("imagesize", Parsers.INT, 2, a -> {
            this.imageWidth = (Integer)a.get(0);
            this.imageHeight = (Integer)a.get(1);
        });
        this.autoscale = params.getBoolean("autoscale", true);
    }

    private void loadMapDimensions(ResourceLocation rl) {
        Tuple<Integer, Integer> dimensions = Image.getImageDimensions(rl);
        this.fileWidth = (Integer)dimensions.func_76341_a();
        this.fileHeight = (Integer)dimensions.func_76340_b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Tuple<Integer, Integer> getImageDimensions(ResourceLocation resourceLocation) {
        int pos = resourceLocation.func_110623_a().lastIndexOf(".");
        if (pos == -1) {
            throw new IllegalStateException("No extension for file: " + resourceLocation.toString());
        }
        String suffix = resourceLocation.func_110623_a().substring(pos + 1);
        Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(suffix);
        while (it.hasNext()) {
            Tuple tuple;
            Throwable throwable;
            ImageInputStream stream;
            ImageReader reader;
            block18: {
                block19: {
                    reader = it.next();
                    stream = ImageIO.createImageInputStream(Minecraft.func_71410_x().func_195551_G().func_199002_a(resourceLocation).func_199027_b());
                    throwable = null;
                    reader.setInput(stream);
                    tuple = new Tuple((Object)reader.getWidth(reader.getMinIndex()), (Object)reader.getHeight(reader.getMinIndex()));
                    if (stream == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                stream.close();
            }
            reader.dispose();
            return tuple;
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (stream != null) {
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        Log.getLogger().warn((Object)e);
                        reader.dispose();
                    }
                }
                catch (Throwable throwable6) {
                    reader.dispose();
                    throw throwable6;
                }
            }
        }
        return new Tuple((Object)0, (Object)0);
    }

    public void setImage(String source) {
        this.setImage(source, 0, 0, 0, 0);
    }

    public void setImage(String source, int offsetX, int offsetY, int w, int h) {
        this.setImage(source != null ? new ResourceLocation(source) : null, offsetX, offsetY, w, h);
    }

    public void setImage(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        this.resourceLocation = loc;
        this.u = offsetX;
        this.v = offsetY;
        this.imageWidth = w;
        this.imageHeight = h;
        this.loadMapDimensions(loc);
    }

    public void setImage(ResourceLocation loc, int offsetX, int offsetY, int w, int h, boolean customSized) {
        this.customSized = customSized;
        this.resourceLocation = loc;
        this.u = offsetX;
        this.v = offsetY;
        this.imageWidth = w;
        this.imageHeight = h;
        this.loadMapDimensions(loc);
    }

    public void setImage(ResourceLocation loc) {
        this.setImage(loc, 0, 0, 0, 0);
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        this.mc.func_110434_K().func_110577_a(this.resourceLocation);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.customSized) {
            Image.func_238466_a_((MatrixStack)ms, (int)this.x, (int)this.y, (int)this.getWidth(), (int)this.getHeight(), (float)this.u, (float)this.v, (int)(this.imageWidth != 0 ? this.imageWidth : this.fileWidth), (int)(this.imageHeight != 0 ? this.imageHeight : this.fileHeight), (int)this.fileWidth, (int)this.fileHeight);
        } else {
            this.func_238474_b_(ms, this.x, this.y, this.u, this.v, this.imageWidth != 0 ? this.imageWidth : this.getWidth(), this.imageHeight != 0 ? this.imageHeight : this.getHeight());
        }
        RenderSystem.disableBlend();
    }
}

